/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.IMPBaseEntityBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntitys;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.inventory.BoomboxMenu;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.server.music.ringer.IBoomboxRinger;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.imp.util.IMPItemUtil;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class BoomboxBlockEntity
extends IMPBaseEntityBlockEntity
implements IBoomboxRinger {
    private final BoomboxData boomboxData;
    private final class_2371<class_1799> items = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
    private final UUID ringerUUID = UUID.randomUUID();

    public BoomboxBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)IMPBlockEntitys.BOOMBOX.get(), blockPos, blockState);
        this.boomboxData = new BoomboxData(new BoomboxData.DataAccess(){

            @Override
            public class_1799 getCassetteTape() {
                return BoomboxBlockEntity.this.getCassetteTape();
            }

            @Override
            public class_1799 getAntenna() {
                return BoomboxBlockEntity.this.getAntenna();
            }

            @Override
            public boolean isPower() {
                return BoomboxBlockEntity.this.isPower();
            }

            @Override
            public void setPower(boolean power) {
                BoomboxBlockEntity.this.setPower(power);
            }

            @Override
            public IMusicRinger getRinger() {
                return BoomboxBlockEntity.this;
            }

            @Override
            public class_243 getPosition() {
                return new class_243((double)BoomboxBlockEntity.this.method_11016().method_10263(), (double)BoomboxBlockEntity.this.method_11016().method_10264(), (double)BoomboxBlockEntity.this.method_11016().method_10260());
            }

            @Override
            public void setCassetteTape(class_1799 stack) {
                BoomboxBlockEntity.this.setItemNoUpdate(0, stack);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                BoomboxBlockEntity.this.method_5431();
            }
        });
    }

    public class_1799 method_5434(int i, int j) {
        if (i == 0) {
            class_1799 old = this.method_5438(0).method_7972();
            class_1799 ret = super.method_5434(i, j);
            this.boomboxData.setOldCassetteTape(old);
            return ret;
        }
        return super.method_5434(i, j);
    }

    public void method_5447(int i, class_1799 stack) {
        if (i == 0) {
            this.boomboxData.onCassetteTapeChange(stack, this.getCassetteTape());
        }
        this.setItemNoUpdate(i, stack);
    }

    public void setItemNoUpdate(int i, class_1799 stack) {
        super.method_5447(i, stack);
    }

    public void setBoomboxData(BoomboxData data) {
        this.boomboxData.load(data.save(new class_2487(), false, false), false, false);
    }

    public class_1799 createRetainDropItem() {
        return BoomboxItem.createByBE(this, false);
    }

    public boolean isRetainDrop() {
        return true;
    }

    public boolean isRetainEmpty() {
        return false;
    }

    protected class_2561 method_17823() {
        return ((class_2248)IMPBlocks.BOOMBOX.get()).method_9518();
    }

    protected class_1703 method_5465(int i, @NotNull class_1661 inventory) {
        return new BoomboxMenu(i, inventory, (class_1263)this, this.method_11016(), class_1799.field_8037, null);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.boomboxData.load(tag.method_10562("BoomBoxData"), false, false);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10566("BoomBoxData", (class_2520)this.boomboxData.save(new class_2487(), false, false));
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, BoomboxBlockEntity blockEntity) {
        blockEntity.boomboxData.tick(level);
        if (!level.method_8608()) {
            blockEntity.ringerTick();
            blockEntity.setRaisedHandleState(blockEntity.boomboxData.getHandleRaisedProgress() >= blockEntity.boomboxData.getHandleRaisedMax());
            blockEntity.sync();
            blockEntity.method_5431();
        }
    }

    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        tag.method_10566("BoomBoxData", (class_2520)this.boomboxData.save(new class_2487(), false, true));
        return super.getSyncData(player, tag);
    }

    public void onSync(class_2487 tag) {
        super.onSync(tag);
        this.boomboxData.load(tag.method_10562("BoomBoxData"), false, true);
    }

    public boolean method_5437(int i, class_1799 itemStack) {
        return i == 0 && IMPItemUtil.isCassetteTape(itemStack) || i == 1 && IMPItemUtil.isAntenna(itemStack);
    }

    @NotNull
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public void setRaisedHandleState(boolean raised) {
        class_2680 bs = (class_2680)this.method_11010().method_11657((class_2769)BoomboxBlock.RAISED, (Comparable)Boolean.valueOf(raised));
        this.method_10997().method_8652(this.method_11016(), bs, 2);
    }

    public BoomboxData getBoomboxData() {
        return this.boomboxData;
    }

    @Override
    public class_2487 onInstruction(class_3222 player, String name, int num, class_2487 data) {
        class_2487 ret = this.boomboxData.onInstruction(player, name, num, data);
        if (ret != null) {
            return ret;
        }
        return super.onInstruction(player, name, num, data);
    }

    public class_1799 getCassetteTape() {
        return this.method_5438(0);
    }

    public class_1799 getAntenna() {
        return this.method_5438(1);
    }

    @Override
    public class_2561 getRingerName() {
        return this.method_17823();
    }

    @Override
    public UUID getRingerUUID() {
        return this.ringerUUID;
    }

    @Override
    public boolean isRingerExist() {
        if (this.method_10997() == null || this.field_11863 != this.method_10997()) {
            return false;
        }
        return this.method_11016() != null && this.field_11863.method_8321(this.method_11016()) == this;
    }

    @Override
    @NotNull
    public BoomboxData getRingerBoomboxData() {
        return this.boomboxData;
    }

    @Override
    public class_3218 getRingerLevel() {
        return (class_3218)this.field_11863;
    }

    @Override
    public Pair<class_2960, class_2487> getRingerTracker() {
        return Pair.of((Object)MusicRingManager.FIXED_TRACKER, (Object)MusicRingManager.createFixedTracker(this.getRingerSpatialPosition()));
    }

    @Override
    @NotNull
    public class_243 getRingerSpatialPosition() {
        return new class_243((double)this.method_11016().method_10263() + 0.5, (double)this.method_11016().method_10264() + 0.5, (double)this.method_11016().method_10260() + 0.5);
    }

    public void setByItem(class_1799 stack) {
        this.setPower(BoomboxItem.isPowerOn(stack));
        this.setItemNoUpdate(0, BoomboxItem.getCassetteTape(stack));
        this.setItemNoUpdate(1, BoomboxItem.getAntenna(stack));
        this.setBoomboxData(BoomboxItem.getData(stack));
        this.setPower(BoomboxItem.isPowerOn(stack));
        if (BoomboxItem.getTransferProgress(stack) == 0) {
            this.boomboxData.setHandleRaising(true);
            this.boomboxData.setHandleRaisedProgress(this.boomboxData.getHandleRaisedMax());
            this.boomboxData.setHandleRaisedProgressOld(this.boomboxData.getHandleRaisedMax());
        }
    }
}

